<?php

namespace App\Controllers\Acesso;

use App\Controllers\BaseController;
use App\Models\DeviceModel;
use App\Models\GroupModel;
use App\Entities\DeviceEntity;
use App\Libraries\LibPaginate;

class Monitor extends BaseController
{

    private DeviceEntity $device;
    private GroupModel $group;

    public function __construct()
    {
        $this->model = new DeviceModel();
        $this->group = new GroupModel();
        $this->device = new DeviceEntity();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function index()
    {
        $this->addOnView('groups', $this->group->findAll());
        return view('device/monitor/index', $this->getViewData());
    }

    public function add()
    {
        $this->addOnView('device', $this->device);
        $this->addOnView('types', $this->model->types());
        $this->addOnView('groups', $this->group->findAll());
        return view('device/monitor/edit', $this->getViewData());
    }

    public function edit($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find((int)$id);
        if ($result) {
            $this->device->fill((array)$result);
            $result->ativo = $result->ativo == 'Y' ? '1' : '0';
            $this->addOnView('device', $result);
            $this->addOnView('groups', $this->group->findAll());
            $this->addOnView('types', $this->model->types());
            return view('device/monitor/edit', $this->getViewData());
        } else {
            $this->authUser->setFlashdata('error', 'Device inválido');
            return redirect()->to($url);
        }
    }

    public function addsave()
    {
        $this->device->fill($this->request->getPost());
        $url = previous_url() ?? base_url();
        $this->device->ativo = $this->device->ativo == '1' ? 'Y' : 'N';
        $update = $this->model->save($this->device->toArray());
        if (!empty($update)) {
            $this->authUser->setFlashdata('success', 'Device criado com sucesso');
            return redirect()->to('/device/monitor');
        } else {
            $this->authUser->setFlashdata('error', $update->message);
            return redirect()->to($url);
        }
    }

    public function save($id)
    {
        $url = previous_url() ?? base_url();
        $this->device->fill($this->request->getPost());
        $this->device->id = $id;
        $this->device->ativo = $this->device->ativo == '1' ? 'Y' : 'N';
        $result = $this->model->save($this->device->toArray());
        if ($result) {
            $this->authUser->setFlashdata('success', 'Device atualizado com sucesso');
            return redirect()->to('/device/monitor');
        } else {
            $this->authUser->setFlashdata('error', 'device inválido');
            return redirect()->to($url);
        }
    }

    public function data()
    {
        $data = [];
        $orders = ['id', 'terminal_nome', 'terminal_model', 'terminal_pin', 'grupo_categoria_id', 'ativo', ''];
        $busca = $this->request->getGet('search');
        $model = $this->model->select("
                        terminal.id,
                        terminal.terminal_nome,
                        terminal.terminal_id,
                        terminal.terminal_model,
                        terminal.terminal_ip,
                        terminal.terminal_pin,
                        terminal.grupo_categoria_id,
                        terminal.ativo,
                        grupo_categoria.nome_grupo_categoria
                ")
            ->join('grupo_categoria', 'grupo_categoria.id = terminal.grupo_categoria_id', 'left');
        if ($busca && $busca['value']) {
            $qry = $busca['value'];
            $model->where("concat(terminal.id,terminal.terminal_nome,terminal.terminal_model,terminal.terminal_ip) like '%$qry%'");
        }

        $pagination = new LibPaginate($model, $this->request, 'data', $orders);

        $pagination->addFilter('terminal.grupo_categoria_id', 'group', '=');
        $pagination->addFilter('terminal.terminal_model', 'model', '=');
        $pagination->addFilter('terminal.ativo', 'status', '=');

        $getLista = (object) $pagination->get();
        $lista = $getLista->data;

        $data['recordsTotal'] = $getLista->pagination->rows;
        $data['recordsFiltered'] = $getLista->pagination->rows;
        $data['pagination'] = $getLista->pagination->pages;
        $data['data'] = [];
        foreach ($lista as $value) {
            if ($value->ativo == 'Y') {
                $txSituacao = "<span class=\"badge bg-success\">Ativo</span>";
            } else {
                $txSituacao = "<span class=\"badge bg-danger\">Bloqueado</span>";
            }
            $linkEdit = base_url() . "/device/{$value->id}";
            $btg = "<a href=\"{$linkEdit}\" class=\"btn btn-sm rounded-circle btn-primary btn-soft mb-2\" data-id=\"{$value->id}\"  data-toggle=\"tooltip\" data-placement=\"top\" title=\"Editar\" ><i class=\"fi fi-arrow-right\"></i></a> ";
            $groupButton = "<div class=\"btn-group\" role=\"group\" aria-label=\"Opções\">{$btg}</dvi>";
            $data['data'][] = [
                $value->id,
                $value->terminal_nome,
                $value->terminal_id,
                $value->terminal_ip,
                $value->terminal_model,
                $value->terminal_pin,
                $value->nome_grupo_categoria,
                $txSituacao,
                $groupButton
            ];
        }
        return $this->response->setJSON($data);
    }
}
