<?php

namespace App\Controllers\Acesso;

use App\Controllers\BaseController;
use App\Models\ParamModel;


class Ihm extends BaseController
{

    private ParamModel $param;

    public function __construct()
    {
        $this->param = new ParamModel();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function index()
    {
        $param = $this->parametros($this->param->getParamByName('ihx'));
        $this->addOnView('param', $param);
        $this->addOnView('listaGiro', $this->listaGiro());
        $this->addOnView('listaBloqueiaBraco', $this->listaBloqueiaBraco());
        $this->addOnView('listaLiberacaoBraco', $this->listaLiberacaoBraco());
        $this->addOnView('listaDisplay', $this->listaDisplay());
        $this->addOnView('listaSentidoGiro', $this->listaSentidoGiro());
        $this->addOnView('listaPadraoBarcode', $this->listaPadraoBarcode());
        return view('device/ihx/edit', $this->getViewData());
    }


    public function save()
    {
        $url = previous_url() ?? base_url();
        $params = (object) $this->request->getPost();

        if (!property_exists($params, 'hab_barra1')) {
            $params->hab_barra1 = 0;
        }
        if (!property_exists($params, 'hab_barra2')) {
            $params->hab_barra2 = 0;
        }
        if (!property_exists($params, 'hab_keyb')) {
            $params->hab_keyb = 0;
        }
        if (!property_exists($params, 'hab_rfid1')) {
            $params->hab_rfid1 = 0;
        }
        if (!property_exists($params, 'hab_rfid2')) {
            $params->hab_rfid2 = 0;
        }

        $saveParam = $this->parametros($params);

        $result = $this->param->setParamByName('ihx', json_encode($saveParam), 'JSON');
        if ($result) {
            $this->authUser->setFlashdata('success', 'IHM atualizado com sucesso');
            return redirect()->to('/ihm');
        } else {
            $this->authUser->setFlashdata('error', 'dados inválido');
            return redirect()->to($url);
        }
    }

    private function parametros($data = null)
    {
        return (object) [
            'hab_bio' => is_object($data) && property_exists($data, 'hab_bio')
                ? $data->hab_bio : 0,
            'sentido_bio' => is_object($data) && property_exists($data, 'sentido_bio')
                ? $data->sentido_bio : 'I',
            'mem_cheia_braco' => is_object($data) && property_exists($data, 'mem_cheia_braco')
                ? $data->mem_cheia_braco : 1,
            'hab_sensor_porta' => is_object($data) && property_exists($data, 'hab_sensor_porta')
                ? $data->hab_sensor_porta : '0',
            'hab_sensor_porta_2' => is_object($data) && property_exists($data, 'hab_sensor_porta_2')
                ? $data->hab_sensor_porta_2 : 0,
            'mod_fechadura' => is_object($data) && property_exists($data, 'mod_fechadura')
                ? $data->mod_fechadura : 'M',
            'temp_porta_aberta' => is_object($data) && property_exists($data, 'temp_porta_aberta')
                ? $data->temp_porta_aberta : '01',
            'hab_cofre_coletor' => is_object($data) && property_exists($data, 'hab_cofre_coletor')
                ? $data->hab_cofre_coletor : 0,
            'id_bio' => is_object($data) && property_exists($data, 'id_bio')
                ? $data->id_bio : 0,
            'hab_cofre_burro' => is_object($data) && property_exists($data, 'hab_cofre_burro')
                ? $data->hab_cofre_burro : 0,
            'sensor_cofre' => is_object($data) && property_exists($data, 'sensor_cofre')
                ? $data->sensor_cofre : 0,
            'grau_revista' => is_object($data) && property_exists($data, 'grau_revista')
                ? $data->grau_revista : '00',
            'tipo_revista' => is_object($data) && property_exists($data, 'tipo_revista')
                ? $data->tipo_revista : 1,
            'tempo_revista' => is_object($data) && property_exists($data, 'tempo_revista')
                ? $data->tempo_revista : '00',
            // extras
            'hab_log' => is_object($data) && property_exists($data, 'hab_log')
                ? $data->hab_log : 1,
            // geral
            'giro_entrada' => is_object($data) && property_exists($data, 'giro_entrada')
                ? $data->giro_entrada : 'E',
            'bloq_braco_desc' => is_object($data) && property_exists($data, 'bloq_braco_desc')
                ? $data->bloq_braco_desc : 2,
            'temp_acesso' => is_object($data) && property_exists($data, 'temp_acesso')
                ? $data->temp_acesso : '01',
            'qtd_dig' => is_object($data) && property_exists($data, 'qtd_dig')
                ? $data->qtd_dig : 16,
            'senha_quip' => is_object($data) && property_exists($data, 'senha_quip')
                ? $data->senha_quip : '000000',
            'temp_resp_sw' => is_object($data) && property_exists($data, 'temp_resp_sw')
                ? $data->temp_resp_sw : '01',
            'libera_braco' => is_object($data) && property_exists($data, 'libera_braco')
                ? $data->libera_braco : 0,
            'contador_disp' => is_object($data) && property_exists($data, 'contador_disp')
                ? $data->contador_disp : 0,
            // codbar
            'hab_barra1' => is_object($data) && property_exists($data, 'hab_barra1')
                ? $data->hab_barra1 : 1,
            'sentido_barra1' => is_object($data) && property_exists($data, 'sentido_barra1')
                ? $data->sentido_barra1 : 'E',
            'hab_barra2' => is_object($data) && property_exists($data, 'hab_barra2')
                ? $data->hab_barra2 : 1,
            'sentido_barra2' => is_object($data) && property_exists($data, 'sentido_barra2')
                ? $data->sentido_barra2 : 'I',
            'padrao_barcode' => is_object($data) && property_exists($data, 'padrao_barcode')
                ? $data->padrao_barcode : 0,
            // keyboard
            'hab_keyb' => is_object($data) && property_exists($data, 'hab_keyb')
                ? $data->hab_keyb : 1,
            'sentido_keyb' => is_object($data) && property_exists($data, 'sentido_keyb')
                ? $data->sentido_keyb : 'I',
            'hab_rfid1' => is_object($data) && property_exists($data, 'hab_rfid1')
                ? $data->hab_rfid1 : 0,
            'sentido_rfid1' => is_object($data) && property_exists($data, 'sentido_rfid1')
                ? $data->sentido_rfid1 : 'I',
            'hab_rfid2' => is_object($data) && property_exists($data, 'hab_rfid2')
                ? $data->hab_rfid2 : 0,
            'sentido_rfid2' => is_object($data) && property_exists($data, 'sentido_rfid2')
                ? $data->sentido_rfid2 : 'I',
            // MSG
            'msg01' => is_object($data) && property_exists($data, 'msg01')
                ? $data->msg01 : 'INVALIDO',
            'msg02' => is_object($data) && property_exists($data, 'msg02')
                ? $data->msg02 : 'INATIVO',
            'msg03' => is_object($data) && property_exists($data, 'msg03')
                ? $data->msg03 : 'CANCELADO',
            'msg04' => is_object($data) && property_exists($data, 'msg04')
                ? $data->msg04 : 'BLOQUEADO',
            'msg05' => is_object($data) && property_exists($data, 'msg05')
                ? $data->msg05 : 'SEM PERMISSAO',
            'msg06' => is_object($data) && property_exists($data, 'msg06')
                ? $data->msg06 : 'ENTRADA LIBERADA',
        ];
    }

    private function listaGiro()
    {
        return [
            (object)['key' => 'E', 'value' => 'Esquerda'],
            (object)['key' => 'D', 'value' => 'Direita']
        ];
    }
    private function listaBloqueiaBraco()
    {
        return [
            (object)['key' => 0, 'value' => 'Liberado'],
            (object)['key' => 1, 'value' => 'Controlado'],
            (object)['key' => 2, 'value' => 'Bloqueado'],
        ];
    }

    private function listaDisplay()
    {
        return [
            (object)['key' => 0, 'value' => 'Desativado'],
            (object)['key' => 1, 'value' => 'Anti-horário'],
            (object)['key' => 2, 'value' => 'horário'],
            (object)['key' => 3, 'value' => 'Ambos'],
        ];
    }

    private function listaLiberacaoBraco()
    {
        return [
            (object)['key' => 0, 'value' => 'Não Liberado'],
            (object)['key' => 1, 'value' => 'liberado no sentido anti-horário'],
            (object)['key' => 2, 'value' => 'liberado no sentido horário'],
            (object)['key' => 3, 'value' => 'liberado nos dois sentidos'],
        ];
    }

    private function listaSentidoGiro()
    {
        return [
            (object)['key' => 'E', 'value' => 'Entrada'],
            (object)['key' => 'S', 'value' => 'Saída'],
            (object)['key' => 'I', 'value' => 'Irrelevante'],
        ];
    }
    private function listaPadraoBarcode()
    {
        return [
            (object)['key' => 0, 'value' => '3 de 9'],
            (object)['key' => 1, 'value' => '2 de 5'],
        ];
    }
}
