<?php

namespace App\Controllers\Acesso;

use App\Controllers\BaseController;
use App\Models\GroupModel;
use App\Models\GroupItemModel;
use App\Entities\GroupEntity;

class Group extends BaseController {

    private GroupEntity $group;
    private GroupItemModel $groupItem;

    public function __construct()
    {
        $this->model = new GroupModel();
        $this->groupItem = new GroupItemModel();
        $this->group = new GroupEntity();
    }

    public function initController($request, $response, $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        if (!$this->authUser->logged()) {
            return redirect()->route("auth/signin");
        }
    }

    public function index() {
        $this->addOnView('groups', $this->model->findAll());
        return view('group/index', $this->getViewData());
    }

    public function add()
    {
        $this->addOnView('group', $this->group);
        return view('group/edit', $this->getViewData());
    }

    public function edit($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find((int)$id);
        if ($result) {
            $this->group->fill((array)$result);
            $this->addOnView('group', $result);
            return view('group/edit', $this->getViewData());
        } else {
            $this->authUser->setFlashdata('error', 'Grupo inválido');
            return redirect()->to($url);
        }
    }

    public function category($id)
    {
        $url = previous_url() ?? base_url();
        $result = $this->model->find((int)$id);
        if ($result) {
            $this->group->fill((array)$result);
            $this->addOnView('group', $result);
            $this->addOnView('groupItems', $this->groupItem->getCategoriesByGroup($id));
            return view('group/category', $this->getViewData());
        } else {
            $this->authUser->setFlashdata('error', 'Grupo inválido');
            return redirect()->to($url);
        }
    }

    public function setCategory($id)
    {
        $sts = $this->request->getPost('sts');
        $category = $this->request->getPost('category');
        $data = [
            'id_grupo_categoria' => $id,
            'id_categoria' => $category
        ];
        if($sts==1) {
            $this->groupItem->insert($data);
        } else {
            $this->groupItem->where($data)->delete();
        }
        $data['sts']=$sts;
        return $this->response->setJSON($data);
    }

    public function addsave()
    {
        $this->group->fill($this->request->getPost());
        $url = previous_url() ?? base_url();
        $update = $this->model->save($this->group->toArray());

        if (!empty($update)) {
            $this->authUser->setFlashdata('success', 'Grupo criado com sucesso');
            return redirect()->to('/group');
        } else {
            $this->authUser->setFlashdata('error', $update->message);
            return redirect()->to($url);
        }
    }

    public function save($id)
    {
        $url = previous_url() ?? base_url();
        $this->group->fill($this->request->getPost());
        $this->group->id = $id;
        $result = $this->model->save($this->group->toArray());
        if ($result ) {
            $this->authUser->setFlashdata('success', 'Grupo atualizado com sucesso');
            return redirect()->to('/group');
        } else {
            $this->authUser->setFlashdata('error', 'Grupo inválido');
            return redirect()->to($url);
        }
    }

}
