<?php

namespace App\Controllers\Acesso;

use App\Controllers\BaseController;
use App\Models\DeviceModel;
use App\Models\GroupModel;
use App\Libraries\TicketValidation;

class Acesso extends BaseController
{
    private GroupModel $grupo;
    private TicketValidation $ticketValidation;

    public function __construct()
    {
        $this->model = new DeviceModel();
        $this->grupo = new GroupModel();
        $this->ticketValidation = new TicketValidation();
    }
    public function index()
    {
        return view('access/index');
    }
    public function login()
    {
        $output = (object) [
            'status' => false,
            'id' => null,
            'nome' => null,
            'group' => null,
        ];
        $pin = $this->request->getPost('pin');
        $rs = $this->model->where([
            'terminal_pin' => $pin,
            'ativo' => 1,
        ])
            ->whereIn('terminal_model', ['OUTROS', 'ENTREGA'])
            ->first();

        if ($rs) {
            $output->status = true;
            $output->id = $rs->id;
            $output->nome = $rs->terminal_nome;
            $output->group = $this->grupo->find($rs->grupo_categoria_id);
        }
        return $this->response->setJSON($output);
    }
    public function registro()
    {
        $card = $this->request->getPost('card');
        $terminalId = $this->request->getPost('terminal_id');
        return $this->response->setJSON($this->ticketValidation->validateTicket($card, $terminalId));
    }
}
