<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(false);
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
//$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');

$routes->group('auth', function ($routes) {
    $routes->get('signin', 'Auth\Auth::signin');
    $routes->add('auth', 'Auth\Auth::auth');
    $routes->get('logout', 'Auth\Auth::logout');
});

$routes->get('acesso', 'Acesso\Acesso::index');
$routes->post('acesso/login', 'Acesso\Acesso::login');
$routes->post('acesso/registro', 'Acesso\Acesso::registro');

$routes->post('api/acesso', 'Api\Acesso::login');
$routes->post('api/acesso/register', 'Api\Acesso::register');

$routes->get('limpar', 'Home::clearcache');

$routes->get('publico', 'Monitor\Monitor::publico');
$routes->get('publicopida', 'Monitor\Monitor::publicopida');
$routes->get('publico/state', 'Monitor\Monitor::state');

$routes->get('monitor', 'Monitor\Monitor::index');
$routes->get('monitor/acesso', 'Monitor\Monitor::acesso');
$routes->get('review', 'Monitor\Monitor::review');
$routes->get('review/data', 'Monitor\Monitor::reviewdata');
$routes->get('review/data/(:num)', 'Monitor\Monitor::reviewdata/$1');
$routes->get('review/graphic', 'Monitor\Monitor::graphic');
$routes->get('review/graphic/(:num)', 'Monitor\Monitor::graphic/$1');
$routes->get('monitor/device/(:num)', 'Monitor\Monitor::device/$1');
$routes->get('monitor/photo/(:num)', 'Monitor\Monitor::photo/$1');

$routes->group('/', ['filter' => 'authFilter'], function ($routes) {
    
    $routes->group('dashboard', function ($routes) {
        $routes->get('/', 'Dashboard\Dashboard::home');
        $routes->get('data/quantity/(:num)', 'Dashboard\Dashboard::quantity/$1');
        $routes->get('data/resume/(:num)', 'Dashboard\Dashboard::resume/$1');
        $routes->get('data/(:num)/(:num)', 'Dashboard\Dashboard::data/$1/$2');
    });

    $routes->group('event', function ($routes) {
        $routes->get('/', 'Event\Event::index');
        $routes->get('add', 'Event\Event::add');
        $routes->post('/', 'Event\Event::addsave');
        $routes->get('delete/(:num)', 'Event\Event::delete/$1');
        $routes->get('(:num)', 'Event\Event::edit/$1');
        $routes->post('(:num)', 'Event\Event::save/$1');
        $routes->post('sympla', 'Event\Event::sympla');
    });

    $routes->group('category', function ($routes) {
        $routes->get('/', 'Event\Category::index');
        $routes->get('add', 'Event\Category::add');
        $routes->get('delete/(:num)', 'Event\Category::delete/$1');
        $routes->post('/', 'Event\Category::addsave');
        $routes->get('(:num)', 'Event\Category::edit/$1');
        $routes->post('(:num)', 'Event\Category::save/$1');
    });

    $routes->group('ticket', function ($routes) {
        $routes->get('/', 'Event\Ticket::index');
        $routes->get('data', 'Event\Ticket::data');
        $routes->get('add', 'Event\Ticket::add');
        $routes->post('/', 'Event\Ticket::addsave');
        $routes->get('delete/(:num)', 'Event\Ticket::delete/$1');
        $routes->get('(:num)', 'Event\Ticket::edit/$1');
        $routes->post('(:num)', 'Event\Ticket::save/$1');
        $routes->get('photo/(:num)', 'Event\Ticket::photo/$1');
        $routes->get('(:num)/photo', 'Event\Ticket::getPhoto/$1');
        $routes->post('(:num)/photo', 'Event\Ticket::setPhoto/$1');
        $routes->get('(:num)/registry', 'Event\Ticket::getRegistry/$1');
    });

    $routes->group('group', function ($routes) {
        $routes->get('/', 'Acesso\Group::index');
        $routes->get('add', 'Acesso\Group::add');
        $routes->post('/', 'Acesso\Group::addsave');
        $routes->get('(:num)', 'Acesso\Group::edit/$1');
        $routes->post('(:num)', 'Acesso\Group::save/$1');
        $routes->get('(:num)/category', 'Acesso\Group::category/$1');
        $routes->post('(:num)/category', 'Acesso\Group::setCategory/$1');
    });

    $routes->group('device', function ($routes) {
        $routes->get('/', 'Acesso\Device::index');
        $routes->get('data', 'Acesso\Device::data');
        $routes->get('add', 'Acesso\Device::add');
        $routes->get('delete/(:num)', 'Acesso\Device::delete/$1');
        $routes->post('/', 'Acesso\Device::addsave');
        $routes->get('(:num)', 'Acesso\Device::edit/$1');
        $routes->post('(:num)', 'Acesso\Device::save/$1');
        $routes->get('monitor', 'Acesso\Monitor::index');
        $routes->get('monitor/data', 'Acesso\Monitor::data');
        $routes->get('monitor/add', 'Acesso\Monitor::add');
    });

    $routes->group('ihm', function ($routes) {
        $routes->get('/', 'Acesso\Ihm::index');
        $routes->post('/', 'Acesso\Ihm::save');
    });

    $routes->group('user', function ($routes) {
        $routes->get('/', 'User\User::index');
        $routes->get('add', 'User\User::add');
        $routes->post('/', 'User\User::addsave');
        $routes->get('(:num)', 'User\User::edit/$1');
        $routes->post('(:num)', 'User\User::save/$1');
    });

    $routes->group('report', function ($routes) {
        $routes->get('registry', 'Report\Report::registry');
        $routes->get('registry/data', 'Report\Report::registryData');
        $routes->post('registry/expo', 'Report\Report::expo');
        $routes->get('delivery', 'Report\Report::delivery');
        $routes->get('delivery/data', 'Report\Report::deliveryData');
        $routes->post('delivery/expo', 'Report\Report::deliveryExpo');
        
    });

    $routes->group('integration', function ($routes) {
        $routes->get('/', 'Integration\Integration::index');
        $routes->get('add', 'Integration\Integration::add');
        $routes->get('(:num)', 'Integration\Integration::edit/$1');
        $routes->post('/', 'Integration\Integration::addsave');
        $routes->post('(:num)', 'Integration\Integration::save/$1');
    });

    $routes->group('manage', function ($routes) {
        $routes->get('generate', 'Event\Manage::generate');
        $routes->post('generate', 'Event\Manage::createTicket');
        $routes->get('export', 'Event\Manage::export');
        $routes->post('export', 'Event\Manage::exportTicket');
        $routes->get('database', 'Event\Manage::database');
        $routes->get('database/data', 'Event\Manage::databaseData');
        $routes->post('database', 'Event\Manage::databaseProcess');
        $routes->get('sync', 'Event\Sync::config');
        $routes->post('sync', 'Event\Sync::saveConfig');
        $routes->get('syncconfig', 'Event\Sync::syncconfig');
        $routes->get('startsync', 'Event\Sync::startsync');
        $routes->get('syncevent', 'Event\Sync::syncevent');
        $routes->get('syncsendevent', 'Event\Sync::syncsendevent');
        $routes->get('syncregister', 'Event\Sync::syncregister');
        $routes->get('syncsendregister', 'Event\Sync::syncsendregister');
        $routes->get('syncimage', 'Event\Sync::syncimage');
        $routes->get('syncsendimage', 'Event\Sync::syncsendimage');

        $routes->get('import', 'Event\Manage::import');
        $routes->post('import', 'Event\Manage::importTicket');
        $routes->get('importalter', 'Event\Manage::importAlter');
        $routes->post('importalter', 'Event\Manage::importAlterTicket');

        $routes->get('importsympla', 'Event\ManageSympla::import');
        $routes->post('importsympla', 'Event\ManageSympla::importTicket');
        $routes->get('importsymplaproccess/(:num)', 'Event\ManageSympla::process/$1');
        $routes->get('removesymplaproccess/(:num)', 'Event\ManageSympla::removeproccess/$1');
        $routes->post('processasympla/(:num)', 'Event\ManageSympla::processasympla/$1');
        $routes->get('importsympla/(:num)/selcategory', 'Event\ManageSympla::selectCategory/$1');
        
        $routes->get('importcredenciart', 'Event\ManageCredenciart::import');
        $routes->post('importcredenciart', 'Event\ManageCredenciart::importTicket');
        $routes->get('removecredenciartproccess/(:num)', 'Event\ManageCredenciart::removeproccess/$1');
        
    });
});

$routes->group('api', function ($routes) {
    $routes->group('auth', ['filter' => 'loginFilter'], function ($routes) {
        $routes->post('login', 'Api\Auth::login');
    });
    $routes->group('accreditation', ['filter' => 'apiFilter'], function ($routes) {
        $routes->get('ticket', 'Api\Accreditation::ticket');
        $routes->post('(:num)', 'Api\Accreditation::update/$1');
        $routes->post('(:num)/status', 'Api\Accreditation::changestatus/$1');
        $routes->post('(:num)/image', 'Api\Accreditation::image/$1');
    });
    $routes->group('collector', function ($routes) {
        $routes->post('base', 'Api\Collector::index');
        $routes->post('(:num)', 'Api\Accreditation::update/$1');
        $routes->post('(:num)/status', 'Api\Accreditation::changestatus/$1');
        $routes->post('(:num)/image', 'Api\Accreditation::image/$1');
    });
});

$routes->resource('api/event', ['Api\Event', 'filter' => 'apiFilter', 'placeholder' => '(:num)']);
$routes->resource('api/category', ['Api\Category', 'filter' => 'apiFilter', 'placeholder' => '(:num)']);
$routes->resource('api/ticket', ['Api\Ticket', 'filter' => 'apiFilter', 'placeholder' => '(:num)']);
$routes->get('api/ticket/image/(:num)', 'Api\Ticket::getImage/$1', ['filter' => 'apiFilter']);

$routes->get('api/sync/ticket', 'Api\Sync::syncTicket');
$routes->get('api/sync/register', 'Api\Sync::syncRegister');
$routes->get('api/sync/category', 'Api\Sync::syncCategory');
$routes->get('api/sync/env', 'Api\Sync::syncEnv');
$routes->get('api/sync/photo', 'Api\Sync::syncPhoto');

$routes->post('api/sync/ticket', 'Api\Sync::syncPostTicket');
$routes->post('api/sync/register', 'Api\Sync::syncPostRegister');
$routes->post('api/sync/photo', 'Api\Sync::syncPostPhoto');

$routes->group('api/v2', function ($routes) {
    $routes->get('event', 'Api\v2\Event::index');
    $routes->get('event/(:num)', 'Api\v2\Event::show/$1');

    $routes->get('category', 'Api\v2\Event::categoryIndex');
    $routes->get('category/(:num)', 'Api\v2\Event::categoryShow/$1');
    
    $routes->get('ticket', 'Api\v2\Ticket::index');
    $routes->get('ticket/(:num)', 'Api\v2\Ticket::show/$1');
    
    $routes->get('registry', 'Api\v2\Registry::index');
    $routes->post('registry', 'Api\v2\Registry::save');

    $routes->get('delivery', 'Api\v2\Delivery::index');
    $routes->post('delivery', 'Api\v2\Delivery::save');
});

// cli
// $routes->cli('importa/credenciart', 'Commandline\Command::executeImportacaoCredenciart');
/*
$routes->cli('sync/credenciamento', 'Commandline\Command::credenciamento');
$routes->cli('sync/credenciamento/photo', 'Commandline\Command::credenciamentoPhoto');
$routes->cli('sync/ticket', 'Commandline\Command::serverSinc');
$routes->cli('sync/register', 'Commandline\Command::serverSincRegister');
$routes->cli('sync/photo', 'Commandline\Command::serverSincPhoto');
$routes->cli('sync/upload', 'Commandline\Command::uploadSinc');
$routes->cli('sync/uploadphoto', 'Commandline\Command::uploadSincPhoto');
$routes->cli('sync/uploadticket', 'Commandline\Command::uploadSincTicket');
*/
//$routes->cli('integrador/start', 'Commandline\Integrador::start');
//$routes->cli('integrador/end', 'Commandline\Integrador::end');
//$routes->cli('integrador/checkin', 'Commandline\Integrador::checkin');
$routes->cli('integrador/start', 'Commandline\Sync::start');
$routes->cli('integrador/checkin', 'Commandline\Sync::checkin');
$routes->cli('integrador/file/(:num)', 'Commandline\Sync::file/$1');
$routes->cli('integrador/bora', 'Commandline\Integrador::bora');
//$routes->cli('integrador/end', 'Commandline\Sync::end');
//$routes->cli('integrador/checkin', 'Commandline\Sync::checkin');

//ihx
$routes->cli('ihx/integrador/start', 'Commandline\IhxIntegrador::start');
$routes->cli('ihx/integrador/end', 'Commandline\IhxIntegrador::end');
$routes->cli('ihx/integrador/checkin', 'Commandline\IhxIntegrador::checkin');
$routes->cli('ihx/integrador/sinc', 'Commandline\IhxIntegrador::sinc');
$routes->cli('ihx/integrador/leitura', 'Commandline\IhxIntegrador::leitura');

//credenciamento
$routes->cli('ticketeria/integrador/start', 'Commandline\IntegradorTicketeria::start');


/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
